      SUBROUTINE RESLTD(NR,N,X,F,G,A,P,ITNCNT,IFLG,IPR)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C PURPOSE 
C ------- 
C PRINT INFORMATION 
C
C PARAMETERS
C ----------
C NR           --> ROW DIMENSION OF MATRIX
C N            --> DIMENSION OF PROBLEM 
C X(N)         --> ITERATE X[K]
C F            --> FUNCTION VALUE AT X[K]
C G(N)         --> GRADIENT AT X[K]
C A(N,N)       --> HESSIAN AT X[K]
C P(N)         --> STEP TAKEN 
C ITNCNT       --> ITERATION NUMBER K
C IFLG         --> FLAG CONTROLLING INFO TO PRINT 
C IPR          --> DEVICE TO WHICH TO SEND OUTPUT 
C
      DIMENSION X(N),G(N),P(N),A(NR,1)
C PRINT ITERATION NUMBER
      WRITE(IPR,903) ITNCNT
      IF(IFLG.EQ.0) GO TO 120 
C
C PRINT STEP
      WRITE(IPR,907)
      WRITE(IPR,905) (P(I),I=1,N)
C
C PRINT CURRENT ITERATE
  120 CONTINUE
      WRITE(IPR,904)
      WRITE(IPR,905) (X(I),I=1,N)
C
C PRINT FUNCTION VALUE
      WRITE(IPR,906)
      WRITE(IPR,905) F
C
C PRINT GRADIENT
      WRITE(IPR,908)
      WRITE(IPR,905) (G(I),I=1,N)
C
C PRINT HESSIAN FROM ITERATION K
      IF(IFLG.EQ.0) GO TO 140 
      WRITE(IPR,901)
      DO 130 I=1,N
        WRITE(IPR,900) I
        WRITE(IPR,902) (A(I,J),J=1,I)
  130 CONTINUE
C
  140 RETURN
  900 FORMAT(15H RESLTD     ROW,I5)
  901 FORMAT(29H RESLTD       HESSIAN AT X(K))
  902 FORMAT(14H RESLTD       ,5(2X,E20.13))
  903 FORMAT(/21H0RESLTD    ITERATE K=,I5)
  904 FORMAT(18H RESLTD       X(K))
  905 FORMAT(22H RESLTD               ,5(2X,E20.13) )
  906 FORMAT(30H RESLTD       FUNCTION AT X(K))
  907 FORMAT(18H RESLTD       STEP)
  908 FORMAT(30H RESLTD       GRADIENT AT X(K))
      END 
